/* CONSTANTS FOR CLASS NAMES */
var THEME_BLUR_LOADING = 'theme-blur-loading';
var THEME_ACTIVE_SORT_BY = 'theme-active-sortby';

/* CONSTANTS FOR IDs */
var FILTER_ERROR_VALIDATION_MESSAGES = "zs-filter-error-validation-messages";
var FILTER_PRICE_MAX_LESSTHAN_MIN_ERROR_CONTAINER = 'zs-filter-price-maxlessthanmin-error';
var FILTER_PRICE_EMPTY_ERROR_CONTAINER = 'zs-filter-price-empty-error';
var FILTER_PRICE_INVALID_ERROR_CONTAINER = 'zs-filter-price-invalid-error';

/* CONSTANTS FOR DATA ATTRIBUTES */
var DATA_ERROR_MESSAGE = "data-zs-error-message";
var DATA_HREF = 'data-href';
var DATA_SELECTED = 'data-selected';
var DATA_CURRENCY_LIST = 'data-zs-currency-list';
var DATA_THEME_CURRENCY_LIST = 'data-theme-currency-list';
var DATA_CURRENCY_CODE = 'data-zs-currency-code';
var SORT_BY_PLACEHOLDER = '[data-sort-by-products]';
var SORT_BY_WITH_FILTER = '[data-theme-sortby-with-filter]';
var SORT_BY_TARGET = '[data-sort-by-products-target]';
var DATA_MORE_PRODUCT = 'data-has-more-products';
var DATA_LAZY_LOAD = 'data-lazy-load-products';
var DATA_SORT_BY_VALUE = 'data-sort-by-val';
var DATA_THEME_CONTENT_CONTAINER = "data-theme-content-container";
var DATA_SELLING_PRICE = 'data-zs-selling-price';
var DATA_FILTER_CONTAINER = 'data-zs-filter-container';
var DATA_FILTER_OPTION_CONTAINER = 'data-zs-filter-option-container';
var DATA_FILTER_OPTION_TYPE = 'data-zs-filter-option-type';
var DATA_FILTER_OPTION_NAME = 'data-zs-filter-option-name';
var DATA_FILTER_OPTION_CLEAR = 'data-zs-filter-option-clear';
var DATA_FILTER_OPTION_DEFAULT_VALUE_TO_SHOW = 'data-zs-filter-option-default-value-to-show';
var DATA_FILTER_OPTION_VALUE_CONTAINER = 'data-zs-filter-option-value-container';
var DATA_FILTER_OPTION_CATEGORY = 'data-zs-filter-option-category';
var DATA_FILTER_OPTION_VALUE = 'data-zs-filter-option-value';
var DATA_FILTER_OPTION_VALUES_WRAPPER = 'data-zs-filter-option-values-wrapper';
var DATA_FILTER_OPTION_VALUE_TYPE = 'data-zs-filter-option-value-type';
var DATA_FILTER_OPTION_VALUE_ID = 'data-zs-filter-option-value-id';
var DATA_FILTER_OPTION_GROUP_ID = 'data-zs-filter-option-group-id';
var DATA_FILTER_OPTION_VALUE_DATA = 'data-zs-filter-option-value-data';
var DATA_FILTER_OPTION_VALUE_FORMATTED = 'data-zs-filter-option-value-formatted';
var DATA_FILTER_OPTION_VALUE_PRICE_FORMATTED = 'data-zs-filter-option-value-price-formatted';
var DATA_FILTER_OPTION_VALUE_PRICE_MIN = 'data-zs-filter-option-value-price-min';
var DATA_FILTER_OPTION_VALUE_PRICE_MAX = 'data-zs-filter-option-value-price-max';
var DATA_FILTER_OPTION_PRICE_CUSTOM_CONTAINER = 'data-zs-filter-option-price-custom-container';
var DATA_FILTER_OPTION_PRICE_CUSTOM_MIN_ELM = 'data-zs-filter-option-price-custom-min-elm';
var DATA_FILTER_OPTION_PRICE_CUSTOM_MAX_ELM = 'data-zs-filter-option-price-custom-max-elm';
var DATA_FILTER_OPTION_PRICE_CUSTOM_SEPARATOR = 'data-zs-filter-option-price-custom-separator';
var DATA_FILTER_OPTION_PRICE_CUSTOM_MIN_BOX = 'data-zs-filter-option-price-custom-min-box';
var DATA_FILTER_OPTION_PRICE_CUSTOM_MAX_BOX = 'data-zs-filter-option-price-custom-max-box';
var DATA_FILTER_OPTION_PRICE_CUSTOM_BTN = 'data-zs-filter-option-price-custom-btn';
var DATA_FILTER_OPTION_PRICE_CUSTOM_ERROR_CONTAINER = 'data-zs-filter-option-price-custom-error-container';
var DATA_FILTER_OPTION_BRAND_NAME = 'data-zs-filter-option-brand-name';
var DATA_FILTER_OPTION_SEARCH_BRAND = 'data-zs-filter-option-search-brand';
var DATA_FILTER_OPTION_SEARCH_BRAND_CONTAINER = 'data-zs-filter-option-search-brand-container';
var DATA_FILTER_OPTION_BRAND_HIDDEN_SEARCH_MATCHED = 'data-zs-filter-option-brand-hidden-search-matched';
var DATA_FILTER_OPTION_SEARCH_BRAND_RESULT = 'data-zs-filter-option-search-brand-result';
var DATA_FILTER_OPTION_SHOW_MORE_BTN = 'data-zs-filter-option-showmore-btn';
var DATA_FILTER_OPTION_SHOW_LESS_BTN = 'data-zs-filter-option-showless-btn';
var DATA_SELECTED_FILTERS_CONTAINER = 'data-zs-selected-filters-conatainer';
var DATA_FILTER_REFINE_BY_CONTAINER = 'data-zs-filter-refineby-container';
var DATA_FILTER_REFINE_BY_CLEAR_BTN = 'data-zs-filter-refineby-clear-btn';
var DATA_SELECTED_FILTER_SYNTAX = 'data-zs-selected-filter-syntax';
var DATA_SELECTED_FILTER = 'data-zs-selected-filter';
var DATA_SELECTED_FILTER_GROUP_ID = 'data-zs-selected-filter-group-id';
var DATA_SELECTED_FILTER_VALUE = 'data-zs-selected-filter-value';
var DATA_SELECTED_FILTER_TYPE = 'data-zs-selected-filter-type';
var DATA_SELECTED_FILTER_TEXT_CONTAINER = 'data-zs-selected-filter-text-container';
var DATA_SELECTED_FILTER_TEXT = 'data-zs-selected-filter-text';
var DATA_SELECTED_FILTER_COLOR_CONTAINER = 'data-zs-selected-filter-color-container';
var DATA_SELECTED_FILTER_COLOR = 'data-zs-selected-filter-color';
var DATA_SELECTED_FILTER_COLOR_NAME = 'data-zs-selected-filter-color-name';
var DATA_SELECTED_FILTER_USER_RATINGS_CONTAINER = 'data-zs-selected-filter-userratings-container';
var DATA_SELECTED_FILTER_USER_RATINGS = 'data-zs-selected-filter-userratings';
var DATA_SELECTED_FILTER_PRICE_CONTAINER = 'data-zs-selected-filter-price-container';
//var DATA_SELECTED_FILTER_PRICE = 'data-zs-selected-filter-price';
var DATA_SELECTED_FILTER_PRICE_MIN = 'data-zs-selected-filter-price-min';
var DATA_SELECTED_FILTER_PRICE_MAX = 'data-zs-selected-filter-price-max';
var DATA_SELECTED_FILTER_PRICE_SEPARATOR = 'data-zs-selected-filter-price-separator';

/* CONSTANTS FOR MEESAGES/VALUES */
var FILTER_PRICE_MAX_LESSTHAN_MIN_ERROR = "";
var FILTER_PRICE_EMPTY_ERROR = "";
var FILTER_PRICE_INVALID_ERROR = "";
var STORE_CURRENCY_META = "store_currency_meta";
var SEARCH_TERM_IN_CATEGORY = "search_term_in_category";
var MAX_LAZY_COUNT = 2;
var FILTER_TYPE = {
  CATEGORY      : "1",
  PRICE         : "2",
  USER_RATINGS  : "3",
  COLOR         : "4",
  ATTRIBUTES    : "5",
  SPECIFICATION : "6",
  CUSTOM_FIELD  : "7",
  BRAND         : "8",
  TAGS          : "9",
  SEARCH_TERM   : "10"
}
var EVENT_TYPE = {
  CLICK                   : "click",
  CHANGE                  : "change",
  SCROLL                  : "scroll",
  KEY_DOWN                : "keydown",
  PRODUCTS_LIST_SUCCESS   : "zs-event-get-products-list-success"
}
var INSERT_TYPE = {
  APPEND        : "append",
  INNER_HTML    : "innerHTML"
}
var TAG_NAME = {
  SELECT        : "SELECT"
}

var api_requested = false;
var lazy_load_count;

function initSortByPorducts() {
    lazy_load_count = 0;
    bindSortByProducts();
    bindPagination();
    bindProductFilters();
    loadFilterErrorMessagesFromFace();
    selectFilterOptionsFromURLParams(true, true);
}

function bindSortByProducts() {
    var sortByDD = document.querySelectorAll(SORT_BY_PLACEHOLDER);
    if(sortByDD.length == 0){
      return;
    }

    if(sortByDD[0] && sortByDD[0].tagName === TAG_NAME.SELECT) {
      sortByDD[0].addEventListener(EVENT_TYPE.CHANGE, changeSortByProducts, false);
    } else {
        sortByDD.forEach(function(sort_by) {
          sort_by.addEventListener(EVENT_TYPE.CLICK, clickSortByProducts, false);
        });
    }
}

function bindPagination() {
    var scroll_area = document.querySelector('[' + DATA_LAZY_LOAD + ']');
    if(scroll_area) {
        if('IntersectionObserver' in window) {
            var options = {
                root       : null,
                rootMargin : '0px',
                threshold  : 0.2
            };
            var observer = new IntersectionObserver(lazyLoadCallBack, options);
            observer.observe(scroll_area);
        } else {
            document.removeEventListener(EVENT_TYPE.SCROLL, onSrollLazyLoad, false);
            document.addEventListener(EVENT_TYPE.SCROLL, onSrollLazyLoad, false);
        }

    } else {
        var more_product = document.querySelector('[' + DATA_MORE_PRODUCT + ']');
        if(!more_product) {
            return;
        }
        more_product.addEventListener(EVENT_TYPE.CLICK, loadMoreProduct, false);
    }

}

function onSrollLazyLoad() {
    var scroll_area = document.querySelector('[' + DATA_LAZY_LOAD + ']');
    if(scroll_area && isElementInViewport(scroll_area)) {
        fnLazyLoad(scroll_area);
    }
}

function isElementInViewport (el) {
   	var scroll = window.pageYOffset || document.documentElement.scrollTop
    return scroll > el.offsetTop - window.innerHeight/2;
}

function lazyLoadCallBack(entries, observer) {
    entries.forEach( function(entry) {
      if(entry.isIntersecting) {
        var target_element = entry.target;
        if(target_element == null) {
            return;
        }
        fnLazyLoad(target_element);
      }
    });
}

function fnLazyLoad(lazy_load_element) {
    var current_page = parseInt(lazy_load_element.getAttribute('data-current-page-number'));
    current_page++;

    var params = {
        page_number : current_page
    }

    var sortByDD = document.querySelectorAll(SORT_BY_PLACEHOLDER);
    if(sortByDD.length > 0) {
        var clickSortByProducts = document.querySelector('[data-sort-by-products][data-selected]');
        if(clickSortByProducts) {
            params.sort_by = clickSortByProducts.getAttribute('data-sort-by-val');
        } else {
            if(sortByDD[0] && sortByDD[0].value != "") {
                params.sort_by = sortByDD[0].value;
            }
        }
    }
    setProductFilterParams(params, false, false);

    if(api_requested) {
        return;
    }
    api_requested = true
    lazy_load_count++;
    params.send_facet = false;
    loadProducts(params, INSERT_TYPE.APPEND);
}

function showBlurLoading(element) {
  if(element) {
    addClass(element, THEME_BLUR_LOADING);
  }
}

function changeSortByProducts() {
    // Show blur loading
    var blurEl = document.querySelector(SORT_BY_TARGET);
    showBlurLoading(blurEl);

    var params = {
        sort_by : this.value
    };
    setProductFilterParams(params, false, true);

    params.send_facet = false;
    loadProducts(params, INSERT_TYPE.INNER_HTML);
}

function clickSortByProducts(e) {
  var elem = e.target;
  var params = {
      sort_by : elem.getAttribute(DATA_SORT_BY_VALUE)
  };
  setProductFilterParams(params, false, true);
  var sortByDD = document.querySelectorAll(SORT_BY_PLACEHOLDER);
  sortByDD.forEach(function(sort_by) {
      sort_by.removeAttribute(DATA_SELECTED);
      removeClass(sort_by, THEME_ACTIVE_SORT_BY);
  })
  elem.setAttribute(DATA_SELECTED, 'true');
  addClass(elem, THEME_ACTIVE_SORT_BY);

  params.send_facet = false;
  loadProducts(params, INSERT_TYPE.INNER_HTML);
}

function loadMoreProduct() {

    if(api_requested) {
        return;
    }
    api_requested = true;

    var current_page = parseInt(this.getAttribute('data-current-page-number'));
    current_page++;

    var params = {
        page_number : current_page
    }

    var sortByDD = document.querySelectorAll(SORT_BY_PLACEHOLDER);
    if(sortByDD.length > 0) {
      var clickSortByProducts = document.querySelector('[data-sort-by-products][data-selected]');
      if(clickSortByProducts) {
        params.sort_by = clickSortByProducts.getAttribute('data-sort-by-val');
      } else {
        if(sortByDD[0] && sortByDD[0].value != "") {
            params.sort_by = sortByDD[0].value;
        }
      }
    }
    setProductFilterParams(params, false, false);

    params.send_facet = false;
    loadProducts(params, INSERT_TYPE.APPEND);
}

function loadProducts(params, insert_type) {
    sort_by_products.getProducts(params, insert_type);
}

function getProductsResponse(e) {
    api_requested = false;

    var data = e.detail;
    var target = document.querySelector(SORT_BY_TARGET);
    if(!target) {
        return;
    }

    //remove load more or lazy load element
    var lazy_load_elem = document.querySelector('[' + DATA_LAZY_LOAD + ']');
    if(lazy_load_elem) {
        $D.remove(lazy_load_elem);
    }

    var load_more_elelment = document.querySelector('[' + DATA_MORE_PRODUCT + ']');
    if(load_more_elelment) {
        $D.remove(load_more_elelment);
    }

    if(data.insert_type === INSERT_TYPE.APPEND) {
        target.insertAdjacentHTML('beforeend', data.content);
        //three time lazy load and then convert to load more button
        if(lazy_load_count >= MAX_LAZY_COUNT) {
            var lazy_load_elem = document.querySelector('[' + DATA_LAZY_LOAD + ']');
            if(lazy_load_elem) {
                lazy_load_elem.removeAttribute(DATA_LAZY_LOAD);
                lazy_load_elem.setAttribute(DATA_MORE_PRODUCT, "");
                var lazy_load_content = '<span class="zpbutton-wrapper zpbutton zpbutton-type-primary zpbutton-size-md zpbutton-style-none">'+i18n.get("product.pagination.loadmore")+'</span>';
                setInnerHTMLForElement(lazy_load_elem, lazy_load_content);
            }
        }
    } else if(data.insert_type === INSERT_TYPE.INNER_HTML) {
        setInnerHTMLForElement(target, data.content);

        /* Hiding Sortby when there is one or no products in the filter result */

        var filteredProd = target.querySelectorAll('[data-zs-product-id]');
        var sortbyWithFilter = document.querySelector(SORT_BY_WITH_FILTER);
        if(sortbyWithFilter){
          sortbyWithFilter.style.display = (filteredProd.length < 2)?"none":"flex";
        }

        /* Remove blur loading on product list container */
        removeClass(target, THEME_BLUR_LOADING);

        /* If filters response available */

        var filter_container = document.querySelector('[' + DATA_FILTER_CONTAINER+ ']');

        var filterContainerOverlay = document.querySelector('[data-theme-product-filter-overlay]');
        if(filter_container){
          var isFilterContainer = filter_container.classList.contains('theme-mobile-filter-show');
        }
        if(filterContainerOverlay){
          var isFilterOverlay = filterContainerOverlay.classList.contains('theme-mobile-filter-overlay-show');
        }

        if(data.is_filters && data.is_facet_sent && filter_container) {
          /* Remove blur loading on filter container */
          if(typeof data.filters_content != "undefined") {
            setInnerHTMLForElement(filter_container, data.filters_content);
            (data.filters_content == "") ? hideElement(filter_container) : showElement(filter_container);
          }

          selectFilterOptionsFromURLParams(false, false);
          removeClass(filter_container, THEME_BLUR_LOADING);

          if(isFilterContainer){
            removeClass(filter_container,'theme-mobile-filter-show');
          }
          if(filterContainerOverlay && isFilterOverlay){
            removeClass(filterContainerOverlay,'theme-mobile-filter-overlay-show');
          }
          if(isFilterContainer && filterContainerOverlay && isFilterOverlay){
            document.getElementsByTagName("body")[0].style.overflow = 'auto';
          }
        }

        lazy_load_count = 0;
        try {
          product_review.clearCache();
        } catch(e) {
        }
        product_list_coupon.clearLoadedIds();
    }

    try {
    	cart.productQuickLookAddToCart(target);
    } catch (e) {
    }

    product_list_coupon.init();
    multi_currency.convertCurrencyPrice();

    product_option.init();
    product_option.resetAddToCart("", document);
    image_lazy_load.init();
    bindPagination();
    bindProductFilters();

}

/* START: Product Filters - Facet Search */

function isFilterContainerPresent() {
    /*
     *  Returns true, if filter container available [Filter enabled case]
     *  Returns false, if filter container is not available [Filter disabled/unavailable case]
     */
  var filter_container = document.querySelector('[' + DATA_FILTER_CONTAINER + ']');
  if(filter_container) {
    return true;
  }
  return false;
}

function loadFilterErrorMessagesFromFace() {
  if(!isFilterContainerPresent()) {
    return;
  }
  /* Get error messages from face */
  var filter_error_validation_messages = $D.getById(FILTER_ERROR_VALIDATION_MESSAGES);
  if(filter_error_validation_messages) {
    var price_max_less_than_min_error = $D.getById(FILTER_PRICE_MAX_LESSTHAN_MIN_ERROR_CONTAINER);
    if(price_max_less_than_min_error) {
      FILTER_PRICE_MAX_LESSTHAN_MIN_ERROR = price_max_less_than_min_error.getAttribute(DATA_ERROR_MESSAGE);
    }
    var price_empty_error = $D.getById(FILTER_PRICE_EMPTY_ERROR_CONTAINER);
    if(price_empty_error) {
      FILTER_PRICE_EMPTY_ERROR = price_empty_error.getAttribute(DATA_ERROR_MESSAGE);
    }
    var price_invalid_error = $D.getById(FILTER_PRICE_INVALID_ERROR_CONTAINER);
    if(price_invalid_error) {
      FILTER_PRICE_INVALID_ERROR = price_invalid_error.getAttribute(DATA_ERROR_MESSAGE);
    }
  }
}

window.addEventListener('popstate', (event) => {
  /*
   *  This section would be executed if browser back or forward is triggered
   *  Clear all selected filter & apply filters present in URL params
   */
  var filter_container = document.querySelector('[' + DATA_FILTER_CONTAINER + ']');
  var selected_filters_container = document.querySelector('[' + DATA_SELECTED_FILTERS_CONTAINER + ']');
  var selected_filters = selected_filters_container.querySelectorAll('[' + DATA_SELECTED_FILTER + ']');
  for(var i=0; i < selected_filters.length; i++) {
    var selected_filter = selected_filters[i];
    selected_filter.remove();
  }
  var filter_refine_by_container = selected_filters_container.querySelector('[' + DATA_FILTER_REFINE_BY_CONTAINER + ']');
  hideElement(filter_refine_by_container);
  hideElement(selected_filters_container);
  var queryString = window.location.search;
  (!queryString) ? getProductsBasedOnFilter() : selectFilterOptionsFromURLParams(true, true);
});

function bindProductFilters() {
  if(!isFilterContainerPresent()) {
    return;
  }
  var filter_container = document.querySelector('[' + DATA_FILTER_CONTAINER + ']');

  /* Bind checkbox & radio of filter options */
  var filter_option_values = filter_container.querySelectorAll('[' + DATA_FILTER_OPTION_VALUE + ']');
  filter_option_values.forEach(function(filter_option_value) {
    if(filter_option_value.type == "radio") {
      filter_option_value.addEventListener(EVENT_TYPE.CHANGE, clickFilterOptionValue, false);
    } else {
      filter_option_value.addEventListener(EVENT_TYPE.CLICK, clickFilterOptionValue, false);
    }
  });

  /* Bind anchor element of categories */
  var anchor_elms = filter_container.querySelectorAll('[' + DATA_FILTER_OPTION_CATEGORY + ']');
  anchor_elms.forEach(function(anchor_elm) {
    anchor_elm.addEventListener(EVENT_TYPE.CLICK, clickAnchorCategories, false);
  });

  /* Bind 'show more' button */
  var show_more_btns = filter_container.querySelectorAll('[' + DATA_FILTER_OPTION_SHOW_MORE_BTN + ']');
  show_more_btns.forEach(function(show_more_btn) {
    show_more_btn.addEventListener(EVENT_TYPE.CLICK, clickFilterShowMore, false);
  });

  /* Bind 'show less' button */
  var show_less_btns = filter_container.querySelectorAll('[' + DATA_FILTER_OPTION_SHOW_LESS_BTN + ']');
  show_less_btns.forEach(function(show_less_btn) {
    show_less_btn.addEventListener(EVENT_TYPE.CLICK, clickFilterShowLess, false);
  });

  /* Bind collapse toggle */
  var filter_option_names = filter_container.querySelectorAll('[' + DATA_FILTER_OPTION_NAME + ']');
  filter_option_names.forEach(function(filter_option_name) {
    filter_option_name.addEventListener(EVENT_TYPE.CLICK, toggleFilterCollapse, false);
  });

  /* Bind 'custom button' - price custom range */
  var filter_option_price_custom_btn = filter_container.querySelector('[' + DATA_FILTER_OPTION_PRICE_CUSTOM_BTN + ']');
  filter_option_price_custom_btn && filter_option_price_custom_btn.addEventListener(EVENT_TYPE.CLICK, applyCustomPriceFilter, false);

  /* Bind 'clear' of individual filter option containers */
  var filter_options_clear = filter_container.querySelectorAll('[' + DATA_FILTER_OPTION_CLEAR + ']');
  filter_options_clear.forEach(function(filter_option_clear) {
    filter_option_clear.addEventListener(EVENT_TYPE.CLICK, clickIndividualFilterClear, false);
  });

  /* Bind 'clear all' of refine by */
  var filter_refine_by_clear_btn = document.querySelector('[' + DATA_FILTER_REFINE_BY_CLEAR_BTN + ']');
  filter_refine_by_clear_btn && filter_refine_by_clear_btn.addEventListener(EVENT_TYPE.CLICK, clickFilterRefineByClear, false);

  /* Hide/Show brand search field  */
  var brand_search_fields = document.querySelectorAll('[' + DATA_FILTER_OPTION_SEARCH_BRAND + ']');
  for(var i=0; i< brand_search_fields.length; i++) {
    var brand_search_field = brand_search_fields[i];
    var brand_filter_container = brand_search_field.closest('[' + DATA_FILTER_OPTION_CONTAINER + ']');
    var brand_filter_show_more = brand_filter_container.querySelector('[' + DATA_FILTER_OPTION_SHOW_MORE_BTN + ']');
    var brand_search_container = brand_filter_container.querySelector('[' + DATA_FILTER_OPTION_SEARCH_BRAND_CONTAINER + ']');
    if(brand_search_container) {
      (brand_filter_show_more) ? showElement(brand_search_container) : hideElement(brand_search_container);
    }
  }
}

function clickIndividualFilterClear(e) {
  /*
   *  'clear' button click in any of the filter option container
   *  Remove all selected filter option values in that container
   */
   var elem = e.target;
   var filter_option_container = elem.closest('[' + DATA_FILTER_OPTION_CONTAINER + ']');
   var filter_option_value_elms = filter_option_container.querySelectorAll('[' + DATA_FILTER_OPTION_VALUE + ']');
   for(var i=0; i < filter_option_value_elms.length; i++) {
     var filter_option_value_elm = filter_option_value_elms[i];
     if(filter_option_value_elm.checked) {
       filter_option_value_elm.checked = false;
       removeFromSelectedFilters(filter_option_value_elm, false);
     }
   }
   getProductsBasedOnFilter();
}

function clickFilterRefineByClear(e) {
  /*
   *  'clear all' button click of refine by
   *  Remove all selected filter containers
   *  Uncheck/Unselect the filter option value elements
   */
  var filter_container = document.querySelector('[' + DATA_FILTER_CONTAINER + ']');
  var selected_filters_container = document.querySelector('[' + DATA_SELECTED_FILTERS_CONTAINER + ']');
  var selected_filters = selected_filters_container.querySelectorAll('[' + DATA_SELECTED_FILTER + ']');
  for(var i=0; i < selected_filters.length; i++) {
    var selected_filter = selected_filters[i];
    var selected_filter_option_value_id = selected_filter.getAttribute(DATA_SELECTED_FILTER);
    var selected_filter_option_value_elm = filter_container.querySelector('[' + DATA_FILTER_OPTION_VALUE_ID + '="' + selected_filter_option_value_id + '"]');
    if(selected_filter_option_value_elm) {
      selected_filter_option_value_elm.checked = false;
    }
    selected_filter.remove();
  }
  getProductsBasedOnFilter();
}

function clickAnchorCategories(e) {
  /*
   *  anchor element click on any of the categories listed
   *  Check whether current page is a search page
   *  If yes, then navigate to data-href along with search term and selected filters
   *  else just navigate to data-href
   */
   var elem = e.target;
   var filter_option_category_elm = elem.closest('[' +DATA_FILTER_OPTION_CATEGORY + ']');
   if(!filter_option_category_elm) { return; }
   var href = filter_option_category_elm.getAttribute(DATA_HREF);
   if(window.zs_view == "search-products") {
     var filters_query_URL = "";
     var product_filter_key = "pf=";
     var encoded_product_filter_key = encodeURI(product_filter_key);
     var query_string = window.location.search;
     if(query_string && query_string!="") {
       var url_params = new URLSearchParams(query_string);
       var search_term = url_params.get("q");
       if(search_term) {
         filters_query_URL = "?"+SEARCH_TERM_IN_CATEGORY+"=" + search_term;
       }
       var product_filters = url_params.getAll("pf");
       for(var i=0; i < product_filters.length; i++) {
         var product_filter_value = encodeURIComponent(product_filters[i]);
         filters_query_URL = filters_query_URL + ((!search_term && i == 0) ? "?" : "&") + encoded_product_filter_key + product_filter_value;
       }
    }
    href = href + filters_query_URL;
    window.location.href = href;
   } else {
    window.location.href = href;
   }
}

function clickFilterShowMore(e) {
  /*
   * 'show more' button click on any of the filter conatiner
   *  Display hidden filter option value elements
   *  Display 'show less' button
   */
  var elem = e.target;
  var filter_option_container = elem.closest('[' + DATA_FILTER_OPTION_CONTAINER + ']');
  var filter_option_type = filter_option_container.getAttribute(DATA_FILTER_OPTION_TYPE);
  var filter_option_value_containers = filter_option_container.querySelectorAll('[' + DATA_FILTER_OPTION_VALUE_CONTAINER + ']');
  for(var i=0; i < filter_option_value_containers.length; i++) {
    var filter_option_value_container = filter_option_value_containers[i];
    if(filter_option_type == FILTER_TYPE.BRAND) {
      filter_option_value_container.hasAttribute(DATA_FILTER_OPTION_BRAND_HIDDEN_SEARCH_MATCHED) && showElement(filter_option_value_container);
    } else if(filter_option_type == FILTER_TYPE.PRICE) {
      if(filter_option_value_container.hasAttribute(DATA_FILTER_OPTION_PRICE_CUSTOM_CONTAINER)) {
        var filter_option_value_elm = filter_option_value_container.querySelector('[' + DATA_FILTER_OPTION_VALUE + ']');
        var filter_option_value_data = (filter_option_value_elm) ? filter_option_value_elm.getAttribute(DATA_FILTER_OPTION_VALUE_DATA) : "";
        (filter_option_value_data != "") && showElement(filter_option_value_container);
      } else {
        showElement(filter_option_value_container);
      }
    } else {
      showElement(filter_option_value_container);
    }
  }
  var show_more_btn = filter_option_container.querySelector('[' + DATA_FILTER_OPTION_SHOW_MORE_BTN + ']');
  hideElement(show_more_btn);
  var show_less_btn = filter_option_container.querySelector('[' + DATA_FILTER_OPTION_SHOW_LESS_BTN + ']');
  showElement(show_less_btn);
}

function clickFilterShowLess(e) {
  /*
   * 'show less' button click on any of the filter conatiner
   *  Hide filter option value elements based on the configuration
   *  Display 'show more' button
   */
   var elem = e.target;
   var filter_option_container = elem.closest('[' + DATA_FILTER_OPTION_CONTAINER + ']');
   var default_value_to_show = filter_option_container.getAttribute(DATA_FILTER_OPTION_DEFAULT_VALUE_TO_SHOW);
   var filter_option_type = filter_option_container.getAttribute(DATA_FILTER_OPTION_TYPE);
   var filter_option_value_containers = filter_option_container.querySelectorAll('[' + DATA_FILTER_OPTION_VALUE_CONTAINER + ']');
   for(var i=0; i < filter_option_value_containers.length; i++) {
     var filter_option_value_container = filter_option_value_containers[i];
     if(filter_option_type == FILTER_TYPE.BRAND) {
       filter_option_value_container.hasAttribute(DATA_FILTER_OPTION_BRAND_HIDDEN_SEARCH_MATCHED) && hideElement(filter_option_value_container);
     } else if(i > default_value_to_show-1) {
       !filter_option_value_container.hasAttribute(DATA_FILTER_OPTION_PRICE_CUSTOM_CONTAINER) && hideElement(filter_option_value_container);
     }
   }
   var show_more_btn = filter_option_container.querySelector('[' + DATA_FILTER_OPTION_SHOW_MORE_BTN + ']');
   showElement(show_more_btn);
   var show_less_btn = filter_option_container.querySelector('[' + DATA_FILTER_OPTION_SHOW_LESS_BTN + ']');
   hideElement(show_less_btn);
}

function toggleFilterCollapse(e) {
  /*
   *  Contianer show/hide toggle click on any of the filter container
   *  Either show or hide that particular filter container based on toggle value
   */
  var elem = e.target;
  var filter_option_container = elem.closest('[' + DATA_FILTER_OPTION_CONTAINER + ']');
  var filter_option_values_wrapper = filter_option_container.querySelector('[' + DATA_FILTER_OPTION_VALUES_WRAPPER + ']');
  var filter_option_toggle = filter_option_container.querySelector('[' + DATA_FILTER_OPTION_NAME + ']');
  if(filter_option_values_wrapper && filter_option_values_wrapper.style.display == "none"){
    showElement(filter_option_values_wrapper);
    removeClass(filter_option_toggle,'theme-filter-expand-toggle');
    addClass(filter_option_toggle,'theme-filter-close-toggle');
  }else{
    hideElement(filter_option_values_wrapper);
    addClass(filter_option_toggle,'theme-filter-expand-toggle');
    removeClass(filter_option_toggle,'theme-filter-close-toggle');
  }
  // (filter_option_values_wrapper && filter_option_values_wrapper.style.display == "none") ? showElement(filter_option_values_wrapper) : hideElement(filter_option_values_wrapper) ;
}

function applyCustomPriceFilter(e) {
  /*
   * 'Apply' button click on Price filter container
   *  Fetch min and max range values from the custom box & filter based on that price
   */
  e.preventDefault();
  var elem = e.target;
  var is_custom_price_needed = false;
  var filter_option_container = elem.closest('[' + DATA_FILTER_OPTION_CONTAINER + ']');
  var price_custom_error_container = filter_option_container.querySelector('[' + DATA_FILTER_OPTION_PRICE_CUSTOM_ERROR_CONTAINER + ']');
  var price_custom_min_box = filter_option_container.querySelector('[' + DATA_FILTER_OPTION_PRICE_CUSTOM_MIN_BOX + ']');
  var price_custom_max_box = filter_option_container.querySelector('[' + DATA_FILTER_OPTION_PRICE_CUSTOM_MAX_BOX + ']');

  if(isNaN(price_custom_min_box.value) || isNaN(price_custom_max_box.value)) {
    setInnerHTMLForElement(price_custom_error_container, FILTER_PRICE_INVALID_ERROR);
    price_custom_error_container && showElement(price_custom_error_container);
    return;
  }

  var price_from = Number(price_custom_min_box.value);
  var price_to = Number(price_custom_max_box.value);
  if(price_to==0 && price_from==0) {
    setInnerHTMLForElement(price_custom_error_container, FILTER_PRICE_EMPTY_ERROR);
    price_custom_error_container && showElement(price_custom_error_container);
    return;
  } else if((price_to <= price_from) && price_to!=0) {
    setInnerHTMLForElement(price_custom_error_container, FILTER_PRICE_MAX_LESSTHAN_MIN_ERROR);
    price_custom_error_container && showElement(price_custom_error_container);
    return;
  } else {
    is_custom_price_needed = true;
    var filter_option_value_containers = filter_option_container.querySelectorAll('[' + DATA_FILTER_OPTION_VALUE_CONTAINER + ']');
    for(var i=0; i < filter_option_value_containers.length; i++) {
      var filter_option_value_container = filter_option_value_containers[i];
      var filter_option_value_elm = filter_option_value_container.querySelector('[' + DATA_FILTER_OPTION_VALUE + ']');
      var filter_option_value_data = filter_option_value_elm.getAttribute(DATA_FILTER_OPTION_VALUE_DATA);
      if(filter_option_value_data) {
        var filter_option_value_price_data = filter_option_value_data.split("_");
        var filter_option_value_price_from = Number(filter_option_value_price_data[0]);
        var filter_option_value_price_to = Number(filter_option_value_price_data[1]);
        if(filter_option_value_price_from==price_from && filter_option_value_price_to==price_to) {
          is_custom_price_needed = false;
          filter_option_value_elm.click();
          break;
        }
      }
    }
  }
  if(is_custom_price_needed) {
    var filter_option_price_custom_container = filter_option_container.querySelector('[' + DATA_FILTER_OPTION_PRICE_CUSTOM_CONTAINER + ']');
    setCustomPriceDataInCustomContainer(filter_option_price_custom_container, price_from, price_to, true);
  }
}

function searchBrands(elem) {
  /*
   * 'key down' on search field of brand filter container
   *  Show brand filter options based on search term, and hide rest
   *  If no filter option matches, then show respective message
   */
  //var elem = e.target;
  var brand_search_text = elem.value;
  brand_search_text = brand_search_text.trim().toLowerCase();
  var filter_option_container = elem.closest('[' + DATA_FILTER_OPTION_CONTAINER + ']');
  var default_value_to_show = filter_option_container.getAttribute(DATA_FILTER_OPTION_DEFAULT_VALUE_TO_SHOW);
  var filter_option_value_containers = filter_option_container.querySelectorAll('[' + DATA_FILTER_OPTION_VALUE_CONTAINER + ']');
  var show_count = 0;
  var matched_count = 0;
  for(var i=0; i < filter_option_value_containers.length; i++) {
    var filter_option_value_container = filter_option_value_containers[i];
    var brand_name = filter_option_value_container.getAttribute(DATA_FILTER_OPTION_BRAND_NAME);
    if(brand_name) {
      brand_name = brand_name.toLowerCase();
      if(brand_name.includes(brand_search_text)) {
        matched_count++;
        if(show_count >= default_value_to_show) {
          hideElement(filter_option_value_container);
          filter_option_value_container.setAttribute(DATA_FILTER_OPTION_BRAND_HIDDEN_SEARCH_MATCHED, "");
        } else {
          showElement(filter_option_value_container);
          filter_option_value_container.removeAttribute(DATA_FILTER_OPTION_BRAND_HIDDEN_SEARCH_MATCHED);
          show_count++;
        }
      } else {
        hideElement(filter_option_value_container);
        filter_option_value_container.removeAttribute(DATA_FILTER_OPTION_BRAND_HIDDEN_SEARCH_MATCHED);
      }
    }
  }
  var brand_result_error_elm = filter_option_container.querySelector('[' + DATA_FILTER_OPTION_SEARCH_BRAND_RESULT + ']');
  (show_count == 0) ? showElement(brand_result_error_elm) : hideElement(brand_result_error_elm);
  var show_more_btn = filter_option_container.querySelector('[' + DATA_FILTER_OPTION_SHOW_MORE_BTN + ']');
  (matched_count <= default_value_to_show) ? hideElement(show_more_btn) : showElement(show_more_btn);
  var show_less_btn = filter_option_container.querySelector('[' + DATA_FILTER_OPTION_SHOW_LESS_BTN + ']');
  hideElement(show_less_btn);
}

function getFormattedCurrency(value, currency_code) {
	var locale = navigator.language || navigator.browserLanguage || navigator.languages[0] || 'en';
    return new Intl.NumberFormat(locale, {
		style    : 'decimal',
		currency : currency_code,
		maximumFractionDigits:2,
  		minimumFractionDigits:2
	}).format(value);
}

function setFormattedCurrencyForElement(currency_data, element) {
  if(!element) {
    return;
  }
  var element_price = element.getAttribute(DATA_SELLING_PRICE);
  if(element_price && element_price != "") {
      element.innerText = currency_data.symbol_formatted + getFormattedCurrency(element_price, currency_data.code);
  }
}

function constructFormattedCurrencyForCustomPrice() {
  $X.get({
    url: '/api/store-meta', // No I18N
    handler: function () {
      var response = JSON.parse(this.responseText);
      if(response.status_code === '0') {
        var payload = response.payload;
        var currency_data = payload.currency;
        if(currency_data) {
          var filter_option_price_custom_min_elm_list = document.querySelectorAll('[' + DATA_FILTER_OPTION_PRICE_CUSTOM_MIN_ELM + ']');
          var filter_option_price_custom_max_elm_list = document.querySelectorAll('[' + DATA_FILTER_OPTION_PRICE_CUSTOM_MAX_ELM + ']');
          for(var i=0; i<filter_option_price_custom_min_elm_list.length; i++) {
            filter_option_price_custom_min_elm = filter_option_price_custom_min_elm_list[i];
            filter_option_price_custom_max_elm = filter_option_price_custom_max_elm_list[i];
            var price_custom_container = filter_option_price_custom_min_elm.closest('[' + DATA_FILTER_OPTION_PRICE_CUSTOM_CONTAINER + ']');
            var price_custom_element = price_custom_container.querySelector('[' + DATA_FILTER_OPTION_VALUE_ID + ']');
            var filter_option_value_id = price_custom_element.getAttribute(DATA_FILTER_OPTION_VALUE_ID);
            var filter_option_value_data = price_custom_element.getAttribute(DATA_FILTER_OPTION_VALUE_DATA);
            if(filter_option_value_data != "") {
              setFormattedCurrencyForElement(currency_data, filter_option_price_custom_min_elm);
              setFormattedCurrencyForElement(currency_data, filter_option_price_custom_max_elm);
              var selected_filters_container = document.querySelector('[' + DATA_SELECTED_FILTERS_CONTAINER + ']');
              var selected_filter_option_value_elm = selected_filters_container.querySelector('[' + DATA_SELECTED_FILTER + '="' + filter_option_value_id + '"]');
              var selected_filter_option_price_custom_min_elm = selected_filter_option_value_elm.querySelector('[' + DATA_SELECTED_FILTER_PRICE_MIN + ']');
              var selected_filter_option_price_custom_max_elm = selected_filter_option_value_elm.querySelector('[' + DATA_SELECTED_FILTER_PRICE_MAX + ']');
              setFormattedCurrencyForElement(currency_data, selected_filter_option_price_custom_min_elm);
              setFormattedCurrencyForElement(currency_data, selected_filter_option_price_custom_max_elm);
            }
          }
          if(filter_option_price_custom_min_elm_list.length == 0) {
            var queryString = window.location.search;
            if(!queryString) {
              return;
            }
            var urlParams = new URLSearchParams(queryString);
            var product_filters = urlParams.getAll("pf");
            if(product_filters.length == 0) {
              return;
            }
            for(var i=0; i < product_filters.length; i++) {
              var product_filter_value = encodeURIComponent(product_filters[i]);
              if(product_filter_value.includes("custom_price")) {
                var selected_filters_container = document.querySelector('[' + DATA_SELECTED_FILTERS_CONTAINER + ']');
                var selected_filter_option_value_elm = selected_filters_container.querySelector('[' + DATA_SELECTED_FILTER + '="' + product_filter_value + '"]');
                var selected_filter_option_price_custom_min_elm = selected_filter_option_value_elm.querySelector('[' + DATA_SELECTED_FILTER_PRICE_MIN + ']');
                var selected_filter_option_price_custom_max_elm = selected_filter_option_value_elm.querySelector('[' + DATA_SELECTED_FILTER_PRICE_MAX + ']');
                setFormattedCurrencyForElement(currency_data, selected_filter_option_price_custom_min_elm);
                setFormattedCurrencyForElement(currency_data, selected_filter_option_price_custom_max_elm);
              }
            }
          }
        }
      }
    }
  });
}

function setCurrencyCodeInLocalStorage() {
  var data = localStorage.getItem(STORE_CURRENCY_META);
  if(data) {
    var currency_data =  JSON.parse(data);
    if(!currency_data || currency_data.selected_currency_code) {
      return;
    }
    var first_currency_in_list = document.querySelector('[' + DATA_THEME_CURRENCY_LIST + ']');
    currency_data.selected_currency_code = first_currency_in_list.getAttribute(DATA_CURRENCY_CODE);
    localStorage.setItem(STORE_CURRENCY_META, JSON.stringify(currency_data));
  }
}

function setFormattedCurrencyForCustomPrice() {
  /*
   * Check whether currency converter dropdown element is present
   * If true, then call convertCurrencyPrice() method in multi_currency
   * Else manually format the price by getting the org's currency
   */
  var currency_converter_elm = document.querySelector('[' + DATA_CURRENCY_LIST + ']');
  if(currency_converter_elm) {
    if(typeof multi_currency != "undefined") {
      setCurrencyCodeInLocalStorage();
      multi_currency.convertCurrencyPrice();
      return;
    }
  }
  constructFormattedCurrencyForCustomPrice();
}

function clickFilterOptionValue(e) {
  /*
   *  Click on any of the filter option element
   *  If checked/selected, then call method to add that element to selected filter
   *  Else call method to remove that element from the selected filter
   */
  var elem = e.target;
  if(elem.checked) {
    addToSelectedFilters(elem, true);
  } else {
    removeFromSelectedFilters(elem, true);
  }
}

function selectFilterOptionsFromURLParams(set_in_selected_filters, reload_product_list_as_whole) {
  var queryString = window.location.search;
  if(!isFilterContainerPresent() || !queryString) {
    return;
  }
  var urlParams = new URLSearchParams(queryString);
  var product_filters = urlParams.getAll("pf");
  var search_terms_in_category = urlParams.getAll(SEARCH_TERM_IN_CATEGORY);
  if(product_filters.length == 0 && search_terms_in_category.length == 0) {
    return;
  }
  if(search_terms_in_category.length > 0 && set_in_selected_filters) {
    var search_term_in_category = urlParams.get(SEARCH_TERM_IN_CATEGORY);
    var filter_option_obj = {};
    filter_option_obj.filter_option_value_type = FILTER_TYPE.SEARCH_TERM;
    filter_option_obj.filter_option_value_id = SEARCH_TERM_IN_CATEGORY + "_" + search_term_in_category;
    filter_option_obj.filter_option_value_data = search_term_in_category;
    filter_option_obj.filter_option_value_formatted = search_term_in_category;
    addToSelectedFilters(false, false, filter_option_obj);
  }
  var filter_container = document.querySelector('[' + DATA_FILTER_CONTAINER + ']');
  for(var i=0; i < product_filters.length; i++) {
    var product_filter_value = encodeURIComponent(product_filters[i]);
    if(product_filter_value.includes("custom_price")) {
      var filter_option_price_custom_container = filter_container.querySelector('[' + DATA_FILTER_OPTION_PRICE_CUSTOM_CONTAINER + ']');
      var price_data = product_filter_value.split("_");
      var price_from = Number(price_data[2]);
      var price_to = Number(price_data[3]);
      setCustomPriceDataInCustomContainer(filter_option_price_custom_container, price_from, price_to, false);
    }
    var filter_option_value_elm = filter_container.querySelector('[' + DATA_FILTER_OPTION_VALUE_ID + '="' + product_filter_value + '"]');
    if(!filter_option_value_elm) {
      continue;
    }
    var filter_option_values_wrapper = filter_option_value_elm.closest('[' + DATA_FILTER_OPTION_VALUES_WRAPPER + ']');
    filter_option_values_wrapper.style.display = "";
    var filter_option_clear = filter_option_values_wrapper.querySelector('[' + DATA_FILTER_OPTION_CLEAR + ']');
    showElement(filter_option_clear);
    var filter_option_value_type = filter_option_value_elm.getAttribute(DATA_FILTER_OPTION_VALUE_TYPE);
    filter_option_value_elm.checked = true;
    if(filter_option_value_type == FILTER_TYPE.PRICE) {
      var filter_option_value_data = filter_option_value_elm.getAttribute(DATA_FILTER_OPTION_VALUE_DATA);
      setSelectedPriceInCustomBox(filter_option_value_elm, filter_option_value_data);
    }
    set_in_selected_filters && addToSelectedFilters(filter_option_value_elm, false);
  }
  reload_product_list_as_whole ? getProductsBasedOnFilter() : setFormattedCurrencyForCustomPrice();
}

function setCustomPriceDataInCustomContainer(filter_option_price_custom_container, price_from, price_to, select_elm) {
  if(filter_option_price_custom_container) {
    var filter_option_price_custom_min_elm = filter_option_price_custom_container.querySelector('[' + DATA_FILTER_OPTION_PRICE_CUSTOM_MIN_ELM + ']');
    var filter_option_price_custom_max_elm = filter_option_price_custom_container.querySelector('[' + DATA_FILTER_OPTION_PRICE_CUSTOM_MAX_ELM + ']');
    var filter_option_price_custom_separator_elm = filter_option_price_custom_container.querySelector('[' + DATA_FILTER_OPTION_PRICE_CUSTOM_SEPARATOR + ']');

    if(price_from == 0) {
      filter_option_price_custom_min_elm && filter_option_price_custom_min_elm.setAttribute(DATA_SELLING_PRICE, price_to);
      setInnerHTMLForElement(filter_option_price_custom_min_elm, price_to);
      setInnerTextForElement(filter_option_price_custom_separator_elm, "");
      setInnerHTMLForElement(filter_option_price_custom_max_elm, " & " + i18n.get("product_filters.and_below.label"));
      filter_option_price_custom_max_elm && filter_option_price_custom_max_elm.removeAttribute(DATA_SELLING_PRICE);
    } else if(price_to == 0) {
      filter_option_price_custom_min_elm && filter_option_price_custom_min_elm.setAttribute(DATA_SELLING_PRICE, price_from);
      setInnerHTMLForElement(filter_option_price_custom_min_elm, price_from);
      setInnerTextForElement(filter_option_price_custom_separator_elm, "");
      setInnerHTMLForElement(filter_option_price_custom_max_elm, " & " + i18n.get("product_filters.and_above.label"));
      filter_option_price_custom_max_elm && filter_option_price_custom_max_elm.removeAttribute(DATA_SELLING_PRICE);
    } else {
      filter_option_price_custom_min_elm && filter_option_price_custom_min_elm.setAttribute(DATA_SELLING_PRICE, price_from);
      setInnerHTMLForElement(filter_option_price_custom_min_elm, price_from);
      filter_option_price_custom_max_elm && filter_option_price_custom_max_elm.setAttribute(DATA_SELLING_PRICE, price_to);
      setInnerHTMLForElement(filter_option_price_custom_max_elm, price_to);
      setInnerTextForElement(filter_option_price_custom_separator_elm, " - ");
    }

    var filter_option_value_elm = filter_option_price_custom_container.querySelector('[' + DATA_FILTER_OPTION_VALUE + ']');
    var custom_price_filter_option_value_data = price_from + "_" + price_to;
    filter_option_value_elm && filter_option_value_elm.setAttribute(DATA_FILTER_OPTION_VALUE_DATA, custom_price_filter_option_value_data);
    var custom_price_filter_option_value_id = "custom_price_" + custom_price_filter_option_value_data;
    filter_option_value_elm && filter_option_value_elm.setAttribute(DATA_FILTER_OPTION_VALUE_ID, custom_price_filter_option_value_id);
    if(select_elm && filter_option_value_elm) {
      filter_option_value_elm.checked = true;
      addToSelectedFilters(filter_option_value_elm, true);
    }
    showElement(filter_option_price_custom_container);
  }
}

function setSelectedPriceInCustomBox(elem, filter_option_value_data) {
  var price_data = filter_option_value_data.split("_");
  var price_from = Number(price_data[0]);
  var price_to = Number(price_data[1]);

  var filter_option_container = elem.closest('[' + DATA_FILTER_OPTION_CONTAINER + ']');
  var price_custom_min_box = filter_option_container.querySelector('[' + DATA_FILTER_OPTION_PRICE_CUSTOM_MIN_BOX + ']');
  price_custom_min_box.value = (price_from != 0) ? price_from : "";
  var price_custom_max_box = filter_option_container.querySelector('[' + DATA_FILTER_OPTION_PRICE_CUSTOM_MAX_BOX + ']');
  price_custom_max_box.value = (price_to != 0) ? price_to : "";
}

function addToSelectedFilters(elem, reload_product_list, filter_option_obj) {
  /*
   *  Add that element which is passed in parameter to selected filter
   *  If type is 'price' or 'user rating' : replace the values if container is already present for each respectively
   */
   var filter_option_value_type = "";
   var filter_option_value_id = "";
   var filter_option_value_data = "";
   var filter_option_value_formatted = "";

   if(elem) {
     filter_option_value_type = elem.getAttribute(DATA_FILTER_OPTION_VALUE_TYPE);
     filter_option_value_id = elem.getAttribute(DATA_FILTER_OPTION_VALUE_ID);
     filter_option_value_data = elem.getAttribute(DATA_FILTER_OPTION_VALUE_DATA);
     filter_option_value_formatted = elem.getAttribute(DATA_FILTER_OPTION_VALUE_FORMATTED);
   } else {
     filter_option_value_type = filter_option_obj.filter_option_value_type;
     filter_option_value_id = filter_option_obj.filter_option_value_id;
     filter_option_value_data = filter_option_obj.filter_option_value_data;
     filter_option_value_formatted = filter_option_obj.filter_option_value_formatted;
   }

  var selected_filter_syntax = document.querySelector('[' + DATA_SELECTED_FILTER_SYNTAX + ']');
  var selected_filters_container = document.querySelector('[' + DATA_SELECTED_FILTERS_CONTAINER + ']');

  if(filter_option_value_type == FILTER_TYPE.PRICE) {
    //setSelectedPriceInCustomBox(elem, filter_option_value_data);
    var filter_option_value_container = elem.closest('[' + DATA_FILTER_OPTION_VALUE_CONTAINER + ']');
    var filter_option_value_price_formatted = filter_option_value_container.querySelector('[' + DATA_FILTER_OPTION_VALUE_PRICE_FORMATTED + ']');
    var selected_filter_price_container = selected_filters_container.querySelector('[' + DATA_SELECTED_FILTER_PRICE_CONTAINER + ']');
    if(selected_filter_price_container != null) {
      // Price container already available

      var filter_option_value_price_min_elm = filter_option_value_price_formatted.querySelector('[' + DATA_FILTER_OPTION_VALUE_PRICE_MIN + ']');
      var data_selling_price_min = (filter_option_value_price_min_elm.hasAttribute(DATA_SELLING_PRICE)) ? filter_option_value_price_min_elm.getAttribute(DATA_SELLING_PRICE) : "";
      var selected_filter_price_min = selected_filter_price_container.querySelector('[' + DATA_SELECTED_FILTER_PRICE_MIN + ']');
      setInnerTextForElement(selected_filter_price_min, filter_option_value_price_min_elm.innerText);
      selected_filter_price_min.setAttribute(DATA_SELLING_PRICE, data_selling_price_min);

      var filter_option_value_price_max_elm = filter_option_value_price_formatted.querySelector('[' + DATA_FILTER_OPTION_VALUE_PRICE_MAX + ']');
      var data_selling_price_max = (filter_option_value_price_max_elm.hasAttribute(DATA_SELLING_PRICE)) ? filter_option_value_price_max_elm.getAttribute(DATA_SELLING_PRICE) : "";
      var selected_filter_price_max = selected_filter_price_container.querySelector('[' + DATA_SELECTED_FILTER_PRICE_MAX + ']');
      setInnerTextForElement(selected_filter_price_max, filter_option_value_price_max_elm.innerText);

      var selected_filter_price_separator_elm = selected_filter_price_container.querySelector('[' + DATA_SELECTED_FILTER_PRICE_SEPARATOR + ']');
      if(data_selling_price_max != "") {
        showElement(selected_filter_price_separator_elm);
        selected_filter_price_max.setAttribute(DATA_SELLING_PRICE, data_selling_price_max);
      } else {
        hideElement(selected_filter_price_separator_elm);
        selected_filter_price_max.removeAttribute(DATA_SELLING_PRICE);
      }

      selected_filter_price_container.setAttribute(DATA_SELECTED_FILTER, filter_option_value_id);
      selected_filter_price_container.setAttribute(DATA_SELECTED_FILTER_VALUE, filter_option_value_data);

    } else {
      // Add price container syntax
      var selected_filter_price_syntax = selected_filter_syntax.querySelector('[' + DATA_SELECTED_FILTER_PRICE_CONTAINER + ']');
      selected_filter_price_container = selected_filter_price_syntax.cloneNode(true);

      var filter_option_value_price_min_elm = filter_option_value_price_formatted.querySelector('[' + DATA_FILTER_OPTION_VALUE_PRICE_MIN + ']');
      var data_selling_price_min = (filter_option_value_price_min_elm.hasAttribute(DATA_SELLING_PRICE)) ? filter_option_value_price_min_elm.getAttribute(DATA_SELLING_PRICE) : "";
      var selected_filter_price_min = selected_filter_price_container.querySelector('[' + DATA_SELECTED_FILTER_PRICE_MIN + ']');
      setInnerTextForElement(selected_filter_price_min, filter_option_value_price_min_elm.innerText);
      selected_filter_price_min.setAttribute(DATA_SELLING_PRICE, data_selling_price_min);

      var filter_option_value_price_max_elm = filter_option_value_price_formatted.querySelector('[' + DATA_FILTER_OPTION_VALUE_PRICE_MAX + ']');
      var data_selling_price_max = (filter_option_value_price_max_elm.hasAttribute(DATA_SELLING_PRICE)) ? filter_option_value_price_max_elm.getAttribute(DATA_SELLING_PRICE) : "";
      var selected_filter_price_max = selected_filter_price_container.querySelector('[' + DATA_SELECTED_FILTER_PRICE_MAX + ']');
      setInnerTextForElement(selected_filter_price_max, filter_option_value_price_max_elm.innerText);

      var selected_filter_price_separator_elm = selected_filter_price_container.querySelector('[' + DATA_SELECTED_FILTER_PRICE_SEPARATOR + ']');
      if(data_selling_price_max != "") {
        showElement(selected_filter_price_separator_elm);
        selected_filter_price_max.setAttribute(DATA_SELLING_PRICE, data_selling_price_max);
      } else {
        hideElement(selected_filter_price_separator_elm);
        selected_filter_price_max.removeAttribute(DATA_SELLING_PRICE);
      }

      selected_filter_price_container.setAttribute(DATA_SELECTED_FILTER, filter_option_value_id);
      selected_filter_price_container.setAttribute(DATA_SELECTED_FILTER_TYPE, filter_option_value_type);
      selected_filter_price_container.setAttribute(DATA_SELECTED_FILTER_VALUE, filter_option_value_data);
      selected_filters_container.appendChild(selected_filter_price_container);
    }
  } else if(filter_option_value_type == FILTER_TYPE.USER_RATINGS) {
    var selected_filter_user_ratings_container = selected_filters_container.querySelector('[' + DATA_SELECTED_FILTER_USER_RATINGS_CONTAINER + ']');
    if(selected_filter_user_ratings_container != null) {
      // User ratings container already available
      var selected_filter_user_ratings = selected_filter_user_ratings_container.querySelector('[' + DATA_SELECTED_FILTER_USER_RATINGS + ']');
      setInnerHTMLForElement(selected_filter_user_ratings, filter_option_value_data + "&#9733; & up");
      selected_filter_user_ratings_container.setAttribute(DATA_SELECTED_FILTER, filter_option_value_id);
      selected_filter_user_ratings_container.setAttribute(DATA_SELECTED_FILTER_VALUE, filter_option_value_data);
    } else {
      // Add user ratings container syntax
      var selected_filter_user_ratings_syntax = selected_filter_syntax.querySelector('[' + DATA_SELECTED_FILTER_USER_RATINGS_CONTAINER + ']');
      selected_filter_user_ratings_container = selected_filter_user_ratings_syntax.cloneNode(true);
      var selected_filter_user_ratings = selected_filter_user_ratings_container.querySelector('[' + DATA_SELECTED_FILTER_USER_RATINGS + ']');
      setInnerHTMLForElement(selected_filter_user_ratings, filter_option_value_data + "&#9733; & up");
      selected_filter_user_ratings_container.setAttribute(DATA_SELECTED_FILTER, filter_option_value_id);
      selected_filter_user_ratings_container.setAttribute(DATA_SELECTED_FILTER_VALUE, filter_option_value_data);
      selected_filter_user_ratings_container.setAttribute(DATA_SELECTED_FILTER_TYPE, filter_option_value_type);
      selected_filters_container.appendChild(selected_filter_user_ratings_container);
    }
  } else if(filter_option_value_type == FILTER_TYPE.COLOR) {
    var color_data = filter_option_value_formatted.split("_");
    var color_name = color_data[0];
    var color_code = color_data[1];
    var selected_filter_color_syntax = selected_filter_syntax.querySelector('[' + DATA_SELECTED_FILTER_COLOR_CONTAINER + ']');
    var selected_filter_color_container = selected_filter_color_syntax.cloneNode(true);
    var selected_filter_color = selected_filter_color_container.querySelector('[' + DATA_SELECTED_FILTER_COLOR + ']');
    selected_filter_color.style.background = color_code;
    var selected_filter_color_name = selected_filter_color_container.querySelector('[' + DATA_SELECTED_FILTER_COLOR_NAME + ']');
    setInnerTextForElement(selected_filter_color_name, color_name);
    selected_filter_color_container.setAttribute(DATA_SELECTED_FILTER, filter_option_value_id);
    selected_filter_color_container.setAttribute(DATA_SELECTED_FILTER_VALUE, filter_option_value_data);
    selected_filter_color_container.setAttribute(DATA_SELECTED_FILTER_TYPE, filter_option_value_type);
    selected_filters_container.appendChild(selected_filter_color_container);
  } else {
    var selected_filter_text_syntax = selected_filter_syntax.querySelector('[' + DATA_SELECTED_FILTER_TEXT_CONTAINER + ']');
    var selected_filter_text_container = selected_filter_text_syntax.cloneNode(true);
    var selected_filter_text = selected_filter_text_container.querySelector('[' + DATA_SELECTED_FILTER_TEXT + ']');
    setInnerTextForElement(selected_filter_text, filter_option_value_formatted);
    selected_filter_text_container.setAttribute(DATA_SELECTED_FILTER, filter_option_value_id);
    selected_filter_text_container.setAttribute(DATA_SELECTED_FILTER_VALUE, filter_option_value_data);
    selected_filter_text_container.setAttribute(DATA_SELECTED_FILTER_TYPE, filter_option_value_type);
    if(filter_option_value_type == FILTER_TYPE.ATTRIBUTES || filter_option_value_type == FILTER_TYPE.SPECIFICATION) {
      var filter_option_group_id = elem.getAttribute(DATA_FILTER_OPTION_GROUP_ID);
      selected_filter_text_container.setAttribute(DATA_SELECTED_FILTER_GROUP_ID, filter_option_group_id);
    }
    selected_filters_container.appendChild(selected_filter_text_container);
  }
  (reload_product_list) ? getProductsBasedOnFilter() : toggleRefineBy() ;
}

function removeFromSelectedFilters(elem, reload_product_list) {
  /*
   *  Remove that element which is passed in parameter from the selected filters
   */
  var filter_option_value_id = elem.getAttribute(DATA_FILTER_OPTION_VALUE_ID);
  var selected_filters_container = document.querySelector('[' + DATA_SELECTED_FILTERS_CONTAINER + ']');
  var selected_filter = selected_filters_container.querySelector('[' + DATA_SELECTED_FILTER + '="' + filter_option_value_id + '"]');
  selected_filter && selected_filter.remove();
  (reload_product_list) ? getProductsBasedOnFilter() : toggleRefineBy() ;
}

function unSelectFilterOptionValue(elem) {
  /*
   *  'X' icon click on any of the selected filter in 'refine by' container
   *  Call click method for that element which is passed in parameter
   */
  var selected_filter_container = elem.closest('[' + DATA_SELECTED_FILTER + ']');
  var filter_option_value_id = selected_filter_container.getAttribute(DATA_SELECTED_FILTER);
  var filter_option_value_type = selected_filter_container.getAttribute(DATA_SELECTED_FILTER_TYPE);
  var filter_container = document.querySelector('[' + DATA_FILTER_CONTAINER + ']');
  var filter_option_value_elm = filter_container.querySelector('[' + DATA_FILTER_OPTION_VALUE_ID + '="' + filter_option_value_id + '"]');
  if(filter_option_value_elm) {
    filter_option_value_elm.checked = false;
  }
  selected_filter_container.remove();
  getProductsBasedOnFilter();
}

function toggleRefineBy() {
  /*
   *  Show/hide 'Refine by' text and 'clear all' button based on toggle value
   */
  var selected_filters_container = document.querySelector('[' + DATA_SELECTED_FILTERS_CONTAINER + ']');
  var selected_filters = selected_filters_container.querySelectorAll('[' + DATA_SELECTED_FILTER + ']');
  var filter_refine_by_container = selected_filters_container.querySelector('[' + DATA_FILTER_REFINE_BY_CONTAINER + ']');
  if(selected_filters.length > 0) {
    showElement(filter_refine_by_container);
    showElement(selected_filters_container);
  } else {
    hideElement(filter_refine_by_container);
    hideElement(selected_filters_container);
  }
}

function setProductFilterParams(params, push_filters_query_URL, scroll_to_top) {
  if(!isFilterContainerPresent()) {
    return;
  }
  params.is_filters = true;

  var tag_ids = "";
  var brand_ids = "";
  var specification_ids = "";
  var attribute_color_ids = "";
  var attribute_ids = "";
  var price_start = "";
  var price_end = "";
  var price_greater_equals = "";
  var search_term_in_category = "";
  var filters_query_URL = "";
  var product_filter_key = "pf=";
  var encoded_product_filter_key = encodeURI(product_filter_key);
  var query_string = window.location.search;
  var url_params = new URLSearchParams(query_string);
  var search_term = url_params.get("q");
  if(search_term) {
    filters_query_URL = "?q=" + search_term;
  }
  var selected_filters_container = document.querySelector('[' + DATA_SELECTED_FILTERS_CONTAINER + ']');
  var selected_filters = selected_filters_container.querySelectorAll('[' + DATA_SELECTED_FILTER + ']');
  for(var i=0; i < selected_filters.length; i++) {
    var selected_filter = selected_filters[i];
    var filter_option_value_type = selected_filter.getAttribute(DATA_SELECTED_FILTER_TYPE);
    var filter_option_value = selected_filter.getAttribute(DATA_SELECTED_FILTER_VALUE);

    if(push_filters_query_URL) {
      var filter_option_value_id = selected_filter.getAttribute(DATA_SELECTED_FILTER);
      filters_query_URL = filters_query_URL + ((!search_term && i == 0) ? "?" : "&");
      filters_query_URL = filters_query_URL + ((filter_option_value_type != FILTER_TYPE.SEARCH_TERM) ? (encoded_product_filter_key + filter_option_value_id) : (SEARCH_TERM_IN_CATEGORY + "=" + filter_option_value));
    }

    if(filter_option_value_type == FILTER_TYPE.PRICE) {
      var price_data = filter_option_value.split("_");
      if(price_data[1] == 0) {
        price_greater_equals = price_data[0];
      } else {
        price_start = price_data[0];
        price_end = price_data[1];
      }
    } else if(filter_option_value_type == FILTER_TYPE.BRAND) {
      if(brand_ids != "") {
        brand_ids = brand_ids + ",";
      }
      brand_ids = brand_ids + filter_option_value;
    } else if(filter_option_value_type == FILTER_TYPE.TAGS) {
      if(tag_ids != "") {
        tag_ids = tag_ids + ",";
      }
      tag_ids = tag_ids + filter_option_value;
    } else if(filter_option_value_type == FILTER_TYPE.SEARCH_TERM) {
      search_term_in_category = filter_option_value;
    } else if(filter_option_value_type == FILTER_TYPE.COLOR) {
      if(attribute_color_ids != "") {
        attribute_color_ids = attribute_color_ids + ",";
      }
      attribute_color_ids = attribute_color_ids + filter_option_value;
    } else if(filter_option_value_type == FILTER_TYPE.ATTRIBUTES) {
      var filter_group_id = selected_filter.getAttribute(DATA_SELECTED_FILTER_GROUP_ID);
      if(!params["attribute_"+ filter_group_id +"_option_ids"]) {
        if(attribute_ids != "") {
          attribute_ids = attribute_ids + ",";
        }
        attribute_ids = attribute_ids + filter_group_id;
        params["attribute_"+ filter_group_id +"_option_ids"] = filter_option_value;
      } else {
        var attribute_group_option_ids = params["attribute_"+ filter_group_id +"_option_ids"];
        if(attribute_group_option_ids != "") {
          attribute_group_option_ids = attribute_group_option_ids + ",";
        }
        params["attribute_"+ filter_group_id +"_option_ids"] = attribute_group_option_ids + filter_option_value;
      }
    } else if(filter_option_value_type == FILTER_TYPE.SPECIFICATION) {
      var filter_group_id = selected_filter.getAttribute(DATA_SELECTED_FILTER_GROUP_ID);
      if(!params["specification_"+ filter_group_id +"_value_ids"]) {
        if(specification_ids != "") {
          specification_ids = specification_ids + ",";
        }
        specification_ids = specification_ids + filter_group_id;
        params["specification_"+ filter_group_id +"_value_ids"] = filter_option_value;
      } else {
        var specification_group_option_ids = params["specification_"+ filter_group_id +"_value_ids"];
        if(specification_group_option_ids != "") {
          specification_group_option_ids = specification_group_option_ids + ",";
        }
        params["specification_"+ filter_group_id +"_value_ids"] = specification_group_option_ids + filter_option_value;
      }
    }
  }

  /* add filter_option_value_data in params */
  if(tag_ids != "") {
    params.tag_ids = tag_ids;
  }
  if(search_term_in_category != "") {
    params.search_term_in_category = search_term_in_category;
  }
  if(brand_ids != "") {
    params.brand_ids = brand_ids;
  }
  if(attribute_color_ids != "") {
    params.attribute_color_ids = attribute_color_ids;
  }
  if(attribute_ids != "") {
    params.attribute_ids = attribute_ids;
  }
  if(specification_ids != "") {
    params.specification_ids = specification_ids;
  }
  if(price_start != "") {
    params.price_start = price_start;
    params.price_end = price_end;
  }
  if(price_start != "") {
    params.price_start = price_start;
    params.price_end = price_end;
  } else if(price_greater_equals != "") {
    params.price_greater_equals = price_greater_equals;
  }

  /* Push filters_query_URL in current window.location.href */
  if(push_filters_query_URL) {
    filters_query_URL = (filters_query_URL == "") ? "?" : filters_query_URL;
    window.history.pushState("", "", filters_query_URL);
  }

  /* Scroll to filter result */
  if(scroll_to_top) {
    var headerFloat = document.querySelector('[data-header]');
    var refinedFilter = document.querySelector('[' + DATA_FILTER_CONTAINER + ']');
    var refinePos = refinedFilter.offsetTop;
    if(headerFloat){
      var isHeaderFloat = headerFloat.classList.contains('theme-header-animate');
      var headerFloatHeight = headerFloat.clientHeight;
      var scrollPos = refinePos-headerFloatHeight;
    }
    if(refinedFilter && headerFloat && isHeaderFloat && document.documentElement.clientWidth > 992){
      window.scrollTo(0, scrollPos-50);
    }
    else if(refinedFilter && document.documentElement.clientWidth > 992){
      window.scrollTo(0, refinePos-50);
    }
  }

}

function getProductsBasedOnFilter() {
  /*
   *  Fetch selected filter values
   *  Push selected filter values in URL
   */

    toggleRefineBy();

    var elem = document.querySelector(SORT_BY_PLACEHOLDER);
    var params = {};
    if(elem) {
      params.sort_by = elem.value;
    }

    setProductFilterParams(params, true, true);

    /* Show blur loading on product list container */
    var blurEl = document.querySelector(SORT_BY_TARGET);
    showBlurLoading(blurEl);

    /* Show blur loading on filter container */
    blurEl = document.querySelector('[' + DATA_FILTER_CONTAINER+ ']');
    showBlurLoading(blurEl);

    params.send_facet = true;
    loadProducts(params, INSERT_TYPE.INNER_HTML);
}

/* END: Product Filters - Facet Search */

initSortByPorducts();
document.addEventListener(EVENT_TYPE.PRODUCTS_LIST_SUCCESS, getProductsResponse, false);
